% WCDMA Demo Default Init Values
% WCDMAspreadandmoddefinit


fingerEnablesT = [1 0 0];
fingerPhasesT = [0 0 0];
slotFormat = 7;
dpchCode = 255;
scrCode = [63 0];
powerVector = [-10 -10 -15 -12 -12];
numTapsRRC = 48;
overSampling =8;
snrdB = -1;
numTapsChEst = 7;
InstrOn = 0;
numChipsOut = 256;


slotFormat = slotFormat +1;
% Compute Spreading Factor
load slotFormatTable;
% Second Column of SlotFormatTable corresponds to SF
sprdFactor = slotFormatTable(slotFormat,2);
% Second Column of SlotFormatTable corresponds to NumBits
numBits = slotFormatTable(slotFormat,3);

% Compute Filter Delay
latestPath = max(fingerPhases);
filtDelayChEst = (numTapsChEst-1)/2;
rxDelayinFrames = ceil(((numTapsRRC/overSampling)+latestPath)/numChipsOut) + filtDelayChEst;
rxDelay = rxDelayinFrames * numSymbFrame;
rxSlotsDelay = ceil(rxDelay*2/numBits);

% Number Symbols per Frame
numSymbFrame = 256/sprdFactor;

% Instrumentation Default Settings
picture=imread('Switch_On.jpg');

ssName=gcs;